# BAS4SC survey analysis

library(readxl)
library(dplyr)


sumarizator <- function(dt){
  dt <- dt[,6:106]
  tt <- t(dt)
  mat <- matrix(0,dim(dt)[2], 5)
  
  nivoi <- levels(as.factor(tt))
  
  colnames(mat) <- nivoi
  rownames(mat) <- colnames(dt)
  
  for (i in 1:dim(tt)[1]){
    mat[i,nivoi[1]] <- summary(as.factor(tt[i,]))[nivoi[1]]
    mat[i,nivoi[2]] <- summary(as.factor(tt[i,]))[nivoi[2]]
    mat[i,nivoi[3]] <- summary(as.factor(tt[i,]))[nivoi[3]]
    mat[i,nivoi[4]] <- summary(as.factor(tt[i,]))[nivoi[4]]
    mat[i,nivoi[5]] <- summary(as.factor(tt[i,]))[nivoi[5]]
  }
  
  mat[is.na(mat)] <- 0
  return(mat)
}



### Students ###

#Serbia students
data_tab <- read_excel("C:/Users/Logistika/Desktop/SERBIA_Students, postgraduates - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,6:106])))

mat <- sumarizator(data_tab)

col_order <- c("Not important","Important",nivoi[3],nivoi[5],nivoi[4])
srb <- mat[,col_order]
View(srb)

#write.csv(srb,"srb.csv")

#Croatia students
data_tab <- read_excel("C:/Users/Logistika/Downloads/CROATIA_Students, postgraduates - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,6:106])))

mat <- sumarizator(data_tab)

col_order <- c(nivoi[1],nivoi[3],nivoi[2],nivoi[5:4])
cro <- mat[,col_order]
#write.csv(cro,"cro.csv")

#Slovenia students
data_tab <- read_excel("C:/Users/Logistika/Downloads/SLOVENIA_Students, postgraduates - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,6:106])))

mat <- sumarizator(data_tab)

col_order <- c(nivoi[2],nivoi[3],nivoi[1],nivoi[4:5])
slo <- mat[,col_order]
#write.csv(slo,"slo.csv")

#Poland students
data_tab <- read_excel("C:/Users/Logistika/Downloads/PL_Students, postgraduates - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,6:106])))

mat <- sumarizator(data_tab)

col_order <- c(nivoi[4],nivoi[5],nivoi[3],nivoi[2:1])
pl <- mat[,col_order]
#write.csv(pl,"pl.csv")

#Joint table

joint_table<- srb+cro+slo+pl
View(joint_table)
write.csv(joint_table,"jt.csv")

#### Teachers ####

#Serbia
data_tab <- read_excel("C:/Users/Logistika/Downloads/SERBIA_Teachers - BAS4SC (Odpowiedzi).xlsx")

#Hrvatska
data_tab <- read_excel("C:/Users/Logistika/Downloads/CROATIA_Teachers - BAS4SC (Odpowiedzi).xlsx")

#Slovenija
data_tab <- read_excel("C:/Users/Logistika/Downloads/SLOVENIA_Teachers - BAS4SC (Odpowiedzi).xlsx")

#Poljska
data_tab <- read_excel("C:/Users/Logistika/Downloads/PL_Teachers - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,9:109])))

sumarizator2 <- function(dt){
  dt <- dt[,9:109]
  tt <- t(dt)
  mat <- matrix(0,dim(dt)[2], 5)
  
  nivoi <- levels(as.factor(tt))
  
  colnames(mat) <- nivoi
  rownames(mat) <- colnames(dt)
  
  for (i in 1:dim(tt)[1]){
    mat[i,nivoi[1]] <- summary(as.factor(tt[i,]))[nivoi[1]]
    mat[i,nivoi[2]] <- summary(as.factor(tt[i,]))[nivoi[2]]
    mat[i,nivoi[3]] <- summary(as.factor(tt[i,]))[nivoi[3]]
    mat[i,nivoi[4]] <- summary(as.factor(tt[i,]))[nivoi[4]]
    mat[i,nivoi[5]] <- summary(as.factor(tt[i,]))[nivoi[5]]
  }
  
  mat[is.na(mat)] <- 0
  return(mat)
}

mat <- sumarizator2(data_tab)

#Srbija
col_order2 <- c(nivoi[4],nivoi[3],nivoi[5],nivoi[2],nivoi[1])
srb2 <- mat[,col_order2]


#Hrvatska
col_order2 <- c(nivoi[2],nivoi[1],nivoi[3],nivoi[5:4])
cro2 <- mat[,col_order2]


#Slovenija
slo2 <- mat

#Poljska
col_order2 <- c(nivoi[3],nivoi[2],nivoi[1],nivoi[5],nivoi[4])
pl2 <- mat[,col_order2]

#Joint table

joint_table_teachers<- srb2+cro2+slo2+pl2
View(joint_table_teachers)
write.csv(joint_table_teachers,"jt_teachers.csv")

#### Companies ####

#Serbia
data_tab <- read_excel("C:/Users/Logistika/Downloads/SERBIA_Companies - BAS4SC (Odpowiedzi).xlsx")

# Hrvatska
data_tab <- read_excel("C:/Users/Logistika/Downloads/CROATIA_Companies - BAS4SC (Odgovori).xlsx")

#Slovenija
data_tab <- read_excel("C:/Users/Logistika/Downloads/SLOVENIA_Companies - BAS4SC (Odpowiedzi).xlsx")

#Poljska
data_tab <- read_excel("C:/Users/Logistika/Downloads/PL_Companies - BAS4SC (Odpowiedzi).xlsx")

nivoi <- levels(as.factor(t(data_tab[,10:110])))

sumarizator2 <- function(dt){
  dt <- dt[,10:110]
  tt <- t(dt)
  mat <- matrix(0,dim(dt)[2], 5)
  
  nivoi <- levels(as.factor(tt))
  
  colnames(mat) <- nivoi
  rownames(mat) <- colnames(dt)
  
  for (i in 1:dim(tt)[1]){
    mat[i,nivoi[1]] <- summary(as.factor(tt[i,]))[nivoi[1]]
    mat[i,nivoi[2]] <- summary(as.factor(tt[i,]))[nivoi[2]]
    mat[i,nivoi[3]] <- summary(as.factor(tt[i,]))[nivoi[3]]
    mat[i,nivoi[4]] <- summary(as.factor(tt[i,]))[nivoi[4]]
    mat[i,nivoi[5]] <- summary(as.factor(tt[i,]))[nivoi[5]]
  }
  
  mat[is.na(mat)] <- 0
  return(mat)
}

mat <- sumarizator2(data_tab)

#Srbija
col_order3 <- c(nivoi[5],nivoi[2],nivoi[3],nivoi[1],nivoi[4])
srb3 <- mat[,col_order3]

#Hrvatska
col_order3 <- c(nivoi[4],nivoi[1],nivoi[2],nivoi[3],nivoi[5])
cro3 <- mat[,col_order3]

#Slovenija
col_order3 <- c(nivoi[3],nivoi[1],nivoi[2],nivoi[5:4])
slo3 <- mat[,col_order3]

#Poland
col_order3 <- c(nivoi[3],nivoi[2],nivoi[1],nivoi[5:4])
pl3 <- mat[,col_order3]

#Joint table

joint_table_comp<- srb3+cro3+slo3+pl3
View(joint_table_comp)
write.csv(joint_table_comp,"jt_comp.csv")

# Bonus 
#### Sum product weighted method

# Classifying to the the category

library(readxl)
stu <- read_excel("C:/Users/Logistika/Desktop/data/excel/students_postgaraduates.xlsx")
overall <- read_excel("C:/Users/Logistika/Desktop/data/excel/overall2.xlsx")
View(overall)

# Step 1: Calculate total evaluations for each subject
overall$total_evaluations <- (overall$Students + overall$Teachers + overall$Companies)/3

# Sort the subjects based on total_evaluations score in descending order
overall_sorted <- overall[order(overall$total_evaluations, decreasing = TRUE), ]

# Determine the total evaluations threshold for class A (top 30%)
n_subjects <- nrow(overall_sorted)
n_A <- ceiling(n_subjects * 0.3)
total_evaluations_A <- overall_sorted$total_evaluations[n_A]

# Classify subjects into A, B, or C categories based on total evaluations
overall_sorted$category <- ifelse(overall_sorted$total_evaluations >= total_evaluations_A, "A", 
                                  ifelse(overall_sorted$total_evaluations > total_evaluations_A * 0.7, "B", "C"))

# Print the sorted data with the category column
print(overall_sorted)
View(overall_sorted)

write.csv(overall_sorted,"overall_sorted.csv")

